{{
File:    TonePlayer.spin
Version: 1.0
Date:    March 14, 2012

Author:  Kevin McCullough
Company: Gecko Engineering
         "Turning good ideas into great products." 
Phone:   541.660.2314
Email:   Kevin@GeckoEngineering.com
Web:     www.GeckoEngineering.com

Revision History:
v1.0 - 3/14/2012
  Initial release.         
    
Description:
This object allows simple generation of tones at a specified frequency using the
cog's counter module.

Currently uses Kwabena's E555_SPKEngine.spin object, but should eventually
be modified to include everything within this object to simplify the
interface and reduce external code dependencies.

}}

CON
  'Note frequency table (more notes may be added if needed):
  NOTE_OFF      = 0    'Sound is off, useful for rests

  NOTE_Bb_2     = 117
  
  NOTE_C_3      = 130  'Middle C
  NOTE_D_3      = 147
  NOTE_E_3      = 165
  NOTE_F_3      = 175
  NOTE_G_3      = 196
  NOTE_A_3      = 220
  NOTE_B_3      = 247
  '---
  NOTE_C_4      = 262
  NOTE_D_4      = 294
  NOTE_E_4      = 330
  NOTE_F_4      = 349
  NOTE_G_4      = 392
  NOTE_A_4      = 440
  NOTE_B_4      = 494
  '---
  NOTE_C_5      = 523
  NOTE_D_5      = 587
  NOTE_E_5      = 659
  NOTE_F_5      = 698
  NOTE_G_5      = 784
  NOTE_A_5      = 880
  NOTE_B_5      = 988
  '---
  NOTE_C_6      = 1047
  NOTE_D_6      = 1175
  NOTE_E_6      = 1319
  NOTE_F_6      = 1397
  NOTE_G_6      = 1568
  NOTE_A_6      = 1760
  NOTE_B_6      = 1976
  '---
  NOTE_C_7      = 2093
  NOTE_D_7      = 2349
  NOTE_E_7      = 2637
  NOTE_F_7      = 2794
  NOTE_G_7      = 3136
  NOTE_A_7      = 3520
  NOTE_B_7      = 3951
    
  'Note duration table:  
  DUR_WHOLE   = 1600          'Time (in ms) of a whole note.  This may be adjusted to change tempo.
  DUR_2       = DUR_WHOLE/2
  DUR_4       = DUR_2/2
  DUR_8       = DUR_4/2
  DUR_16      = DUR_8/2
  DUR_32      = DUR_16/2
                 

VAR
  byte _speakerPin
  'byte _speakerVolume
  
OBJ
  spk         : "E555_SPKEngine.spin"

PUB Start(speakerPin, speakerVolume)
  _speakerPin := speakerPin
  '_speakerVolume := speakerVolume

  spk.speakerVolume(speakerVolume, _speakerPin)

PUB Tone(frequency, duration_ms)
  spk.speakerFrequency(frequency, _speakerPin)
  waitcnt(cnt + ((clkfreq/1000)*duration_ms))
  spk.speakerFrequency(0, _speakerPin)

PUB SetVolume(speakerVolume)
  spk.speakerVolume(speakerVolume, _speakerPin)  
  